import { useTranslations } from "next-intl";

export default function ContactSection() {
  const t = useTranslations("");
  return (
    <section className="!bg-[#19647D] text-white py-10 px-4" id="contact">
      <h2 className="text-center text-2xl font-bold mb-6">{t("CONTACT US")}</h2>
      <div className="custom-container">
        <div className="w-full h-96 mb-8">
          <iframe
            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3611.1160162852495!2d55.383578!3d25.167833!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x0!2zMjXCsDEwJzA0LjIiTiA1NcKwMjMnMDAuOSJF!5e0!3m2!1sar!2sae!4v1730780000000!5m2!1sar!2sae"
            width="100%"
            height="100%"
            style={{ border: 0 }}
            allowFullScreen
            loading="lazy"
            referrerPolicy="no-referrer-when-downgrade"
            className="w-full h-full rounded-lg shadow-md"
          />
        </div>

        <div className="grid grid-cols-1 md:grid-cols-3 gap-6 text-center">
          <div className="bg-[#114759] p-6 rounded-lg shadow-md flex flex-row items-center gap-3">
            <img
              src="images/icons/location.png"
              alt="Location Icon"
              className="w-8 h-8 mb-2"
            />
            <h3 className="font-semibold text-right">
              الإمارات العربية المتحدة - دبي - مستودع WHG3 الميناء الجاف
            </h3>
          </div>

          <div className="bg-[#114759] p-6 rounded-lg shadow-md flex flex-row gap-2 items-center">
            <img
              src="images/icons/call.png"
              alt="Phone Icon"
              className="w-8 h-8 mb-2"
            />
            <div className="flex flex-col gap-2 items-start">
              <p dir="ltr">Dubai (UAE): +971 544 149 643</p>
              <p dir="ltr">Syria: +971 542 186 565</p>
            </div>
          </div>

          <div className="bg-[#114759] p-6 rounded-lg shadow-md flex flex-row gap-4 items-center">
            <img
              src="images/icons/sms.png"
              alt="Email Icon"
              className="w-8 h-8 mb-2"
            />
            <p>
              <a
                href="mailto:info@fastexpress-uae.com"
                className="hover:underline"
              >
                FASTEXPRESS-UAE.COM
              </a>
            </p>
          </div>
        </div>
      </div>
    </section>
  );
}
