"use client";
import React, { useState } from "react";
import Image from "next/image";
import { motion, AnimatePresence } from "framer-motion";
import { useLocale } from "next-intl";

interface FastItemProps {
  title: string;
  imageSrc?: string;
  content?: string;
}

const FastItem: React.FC<FastItemProps> = ({ title, imageSrc, content }) => {
  const [isOpen, setIsOpen] = useState(false);
  const locale = useLocale();

  const toggleAccordion = () => setIsOpen((prev) => !prev);

  return (
    <div className="flex flex-col w-full">
      <div
        className="flex items-center justify-between gap-2 border-b-2 border-[#888888] pb-2 cursor-pointer"
        onClick={toggleAccordion}
      >
        <h3
          className="text-primary font-bold text-lg md:text-xl"
          style={{ fontFamily: locale === "ar" ? "Cairo" : "" }}
        >
          {title}
        </h3>
        {imageSrc && (
          <motion.div
            animate={{ rotate: isOpen ? 90 : 0 }}
            transition={{ duration: 0.3 }}
            className="flex-shrink-0 transition duration-300"
          >
            <Image
              src={imageSrc}
              width={25}
              height={25}
              alt={title}
              className={`object-contain transition duration-300 ${
                isOpen
                  ? "invert-[20%] sepia-[100%] saturate-[5000%] hue-rotate-[0deg] brightness-100 contrast-100"
                  : ""
              }`}
            />
          </motion.div>
        )}
      </div>

      <AnimatePresence>
        {isOpen && (
          <motion.div
            initial={{ height: 0, opacity: 0 }}
            animate={{ height: "auto", opacity: 1 }}
            exit={{ height: 0, opacity: 0 }}
            transition={{ duration: 0.3 }}
            className="overflow-hidden"
          >
            <p
              className="text-gray-600 text-sm md:text-base mt-2"
              style={{ fontFamily: locale === "ar" ? "Cairo" : "" }}
            >
              {content}
            </p>
          </motion.div>
        )}
      </AnimatePresence>
    </div>
  );
};

export default FastItem;
