"use client";
import React from "react";
import Image from "next/image";
import { motion } from "framer-motion";

interface ServiceItemProps {
  id: string;
  title: string;
  subtitle: string;
  imageSrc?: any;
}

const ServiceItem: React.FC<ServiceItemProps> = ({
  id,
  title,
  subtitle,
  imageSrc,
}) => {
  return (
    <motion.div
      whileHover={{ scale: 1.03 }}
      transition={{ type: "spring", stiffness: 200, damping: 15 }}
      className="flex items-center justify-between gap-1 w-full cursor-pointer"
    >
      <div className="flex items-center justify-between gap-2 border-b-2 border-[#888888] pb-2 w-full">
        <div className="text-gray-400 font-bold text-xl md:text-2xl">{id}</div>

        <div className="flex flex-col gap-1">
          <motion.h3
            whileHover={{}}
            className="relative text-center font-bold text-lg md:text-xl 
             transition duration-500
             bg-gradient-to-r from-primary via-secondary to-primary 
             bg-[length:200%_100%] bg-clip-text text-primary 
             hover:animate-shimmer"
          >
            {title}
          </motion.h3>

          <p className="text-gray-600 text-xs md:text-base mt-1 hover:animate-pulse">
            {subtitle}
          </p>
        </div>

        {imageSrc && (
          <div className="flex-shrink-0">
            <Image
              src={imageSrc}
              width={25}
              height={25}
              alt={title}
              className="!object-contain "
            />
          </div>
        )}
      </div>
    </motion.div>
  );
};

export default ServiceItem;
