"use client";
import React from "react";
import FastItem from "@/componnets/fast-card";
import { useTranslations } from "next-intl";

const WhySection = () => {
  const t = useTranslations("WhySection");

  const services = [
    {
      id: "01",
      title: t("services.speed_title"),
      image: "/images/send.png",
      content: t("services.speed_desc"),
    },
    {
      id: "02",
      title: t("services.security_title"),
      image: "/images/send.png",
      content: t("services.security_desc"),
    },
    {
      id: "03",
      title: t("services.solutions_title"),
      image: "/images/send.png",
      content: t("services.solutions_desc"),
    },
    {
      id: "04",
      title: t("services.prices_title"),
      image: "/images/send.png",
      content: t("services.prices_desc"),
    },
    {
      id: "05",
      title: t("services.support_title"),
      image: "/images/send.png",
      content: t("services.support_desc"),
    },
  ];

  return (
    <section
      className="relative w-full h-auto md:py-16 
             before:absolute before:inset-0 !z-[99] before:bg-[#E5ECF3] 
             before:opacity-[40%] before:content-['']"
      style={{
        backgroundImage: "url('/images/bg_white.jpg')",
        backgroundSize: "cover",
        backgroundPosition: "center",
        backgroundRepeat: "no-repeat",
      }}
    >
      <div className="relative custom-container mx-auto flex flex-col md:flex-row items-center gap-10">
        <div className="md:w-1/2 w-full flex flex-col gap-6">
          <h2 className="text-3xl md:text-4xl font-bold text-secondary">
            {t("title")}
          </h2>
          <div className="flex flex-col gap-4">
            {services.map((service) => (
              <FastItem
                key={service.id}
                imageSrc={service.image}
                title={service.title}
                content={service.content}
              />
            ))}
          </div>
        </div>

        <div className="w-full md:w-1/2 flex justify-center md:justify-end top-0">
          <div
            className="w-full max-w-[400px] h-[450px] rounded-lg"
            style={{
              backgroundImage: "url('/images/container (2).png')",
              backgroundSize: "contain",
              backgroundPosition: "center",
              backgroundRepeat: "no-repeat",
            }}
          />
        </div>
      </div>
    </section>
  );
};

export default WhySection;
