// app/sitemap.ts
import type { MetadataRoute } from "next";

const BASE_URL = process.env.NEXT_PUBLIC_SITE_URL ?? "https://fast-express.com";

const LOCALES = ["en", "ar"] as const;

const SECTIONS = ["services", "about", "contact"];

export default function sitemap(): MetadataRoute.Sitemap {
  const now = new Date();

  const rootRoutes: MetadataRoute.Sitemap = LOCALES.map((locale) => ({
    url: `${BASE_URL}/${locale}`,
    lastModified: now,
    changeFrequency: "weekly",
    priority: 1,
  }));

  const sectionRoutes: MetadataRoute.Sitemap = LOCALES.flatMap((locale) =>
    SECTIONS.map((section) => ({
      url: `${BASE_URL}/${locale}/#${section}`,
      lastModified: now,
      changeFrequency: "weekly",
      priority: 0.8,
    }))
  );

  return [...rootRoutes, ...sectionRoutes];
}
