"use client";
import Image from "next/image";
import { useTranslations, useLocale } from "next-intl";

export default function ImagesSection() {
  const t = useTranslations("ServicesBanner");
  const locale = useLocale();
  const isArabic = locale === "ar";

  return (
    <section className="relative w-full h-[200px] md:h-[220px]">
      <Image
        src="/images/services.jpg"
        alt={isArabic ? "خدماتنا" : "Our Services"}
        fill
        priority
        sizes="100vw"
        className="object-cover"
      />

      <div className="absolute inset-0 bg-[#0f5b88]/60" />

      {/* العنوان */}
      <div className="absolute inset-0 flex items-center justify-center px-4">
        <h2
          className={`text-white text-2xl md:text-3xl font-extrabold tracking-[0.06em] text-center
            ${isArabic ? "" : "uppercase"}`}
        >
          {t("title")}
        </h2>
      </div>
    </section>
  );
}
