import { useTranslations } from "next-intl";

export default function ContactSection() {
  const t = useTranslations("");
  return (
    <section className="!bg-[#19647D] text-white py-10 px-4" id="contact">
      <h2 className="text-center text-2xl font-bold mb-6">{t("CONTACT US")}</h2>
      <div className="custom-container">
        <div className="w-full h-96 mb-8">
          <iframe
            src="https://www.google.com/maps?q=25.276987,55.296249&z=12&output=embed"
            width="100%"
            height="100%"
            loading="lazy"
            className="w-full h-full rounded-lg shadow-md"
          ></iframe>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-3 gap-6 text-center">
          <div className="bg-[#114759] p-6 rounded-lg shadow-md flex flex-row items-center">
            <img
              src="images/icons/location.png"
              alt="Location Icon"
              className="w-8 h-8 mb-2"
            />
            <h3 className="font-semibold">{t("warehouse_dubai")}</h3>
          </div>

          <div className="bg-[#114759] p-6 rounded-lg shadow-md flex flex-row gap-2 items-center">
            <img
              src="images/icons/call.png"
              alt="Phone Icon"
              className="w-8 h-8 mb-2"
            />
            <div className="flex flex-col gap-2 items-start">
              <p>Dubai (UAE): +971 544 149 643</p>
              <p>Syria: +971 542 186 565</p>
            </div>
          </div>

          <div className="bg-[#114759] p-6 rounded-lg shadow-md flex flex-row gap-4 items-center">
            <img
              src="images/icons/sms.png"
              alt="Email Icon"
              className="w-8 h-8 mb-2"
            />
            <p>
              <a href="mailto:info@fastexpress-uae.com" className="">
                FASTEXPRESS-UAE.COM
              </a>
            </p>
          </div>
        </div>
      </div>
    </section>
  );
}
