"use client";
import React from "react";
import ServiceItem from "@/componnets/about-card";
import { useLocale, useTranslations } from "next-intl";

const AboutSection = () => {
  const t = useTranslations("About");
  const locale = useLocale();

  const services = [
    {
      id: "01",
      title: t("services.road_title"),
      subtitle: t("services.road_subtitle"),
      image: "/images/send.png",
    },
    {
      id: "02",
      title: t("services.air_title"),
      subtitle: t("services.air_subtitle"),
      image: "/images/send.png",
    },
    {
      id: "03",
      title: t("services.sea_title"),
      subtitle: t("services.sea_subtitle"),
      image: "/images/send.png",
    },
  ];

  return (
    <section className="custom-container my-[5rem] md:my-[8rem]" id="about">
      <div className="max-w-7xl flex flex-col items-center md:flex-row gap-10">
        <div className="flex-1 flex flex-col gap-6 w-[100%]">
          {services.map((service) => (
            <ServiceItem
              key={service.id}
              imageSrc={service?.image}
              id={service.id}
              title={service.title}
              subtitle={service.subtitle}
            />
          ))}
        </div>

        <div className="flex-1">
          <h2 className="text-secondary h2Text mb-0">{t("title")}</h2>
          <hr className="text-gray-300 my-3" />
          <p
            className="text-md md:text-lg leading-relaxed"
            style={{
              fontFamily: locale === "ar" ? "Cairo" : "Poppins",
            }}
          >
            {t("description")}
          </p>
        </div>
      </div>
    </section>
  );
};

export default AboutSection;
