"use client";

import { ReactNode, useState } from "react";
import { cn } from "@/utlis";
import { DropdownMenu } from "../ui/dropdown-menu";
import { DropdownMenuContent, DropdownMenuTrigger } from "../ui/dropdown-menu";

interface IDropdownMenuProps {
  dropdownMenuTrigger: ReactNode | string | number;
  children: ReactNode | string;
  className?: string;
  btnClassName?: string;
  onOpenChange?: (open: boolean) => void; // <--- add callback if needed
}

export const CustomDropdownMenu = ({
  dropdownMenuTrigger,
  children,
  className,
  btnClassName,
  onOpenChange,
}: IDropdownMenuProps) => {
  const [open, setOpen] = useState(false);

  const handleOpenChange = (value: boolean) => {
    setOpen(value);
    onOpenChange?.(value); // trigger external callback if provided
  };

  return (
    <DropdownMenu open={open} onOpenChange={handleOpenChange}>
      <DropdownMenuTrigger
        className={cn("outline-none cursor-pointer", btnClassName)}
      >
        {dropdownMenuTrigger}
      </DropdownMenuTrigger>
      <DropdownMenuContent className={className}>
        {children}
      </DropdownMenuContent>
    </DropdownMenu>
  );
};
